<?php

declare(strict_types=1);

namespace Avodel\SymfonyBehatApi\Doctrine;

use Behat\Behat\Context\Context;
use Doctrine\Common\DataFixtures\Purger\ORMPurger;
use Doctrine\ORM\EntityManagerInterface;

final class DoctrineORMContext implements Context
{
    public function __construct(private readonly EntityManagerInterface $entityManager)
    {
    }

    /**
     * @BeforeScenario
     */
    public function purgeDatabase(): void
    {
        $connection = $this->entityManager->getConnection();
        $connection->getConfiguration()->setSQLLogger(null);

        $purger = new ORMPurger($this->entityManager);
        $purger->purge();

        $this->entityManager->clear();
    }

    /**
     * @BeforeStep
     */
    public function clearEntityManager(): void
    {
        $this->entityManager->clear();
    }
}
