<?php

declare(strict_types=1);

namespace Avodel\SymfonyBehatApi\HttpClient;

use Behat\Behat\Context\Context;
use Behat\Behat\Hook\Scope\AfterStepScope;
use Behat\Gherkin\Node\PyStringNode;

final class HttpClientContext implements Context
{
    public function __construct(
        private readonly MockClientCallback $mockClientCallback,
    )
    {
    }

    /**
     * @deprecated use there is a stubbed http interaction
     *
     * @Given /^the endpoint "(GET|POST) ([^"]*)" returns a (\d+) status with content:$/
     * @Given /^the endpoint "(GET|POST) ([^"]*)" returns a (\d+) status$/
     */
    public function theEndpointReturnsAStatusWithContent(string $requestMethod, string $url, int $statusCode, ?PyStringNode $string = null): void
    {
        $this->mockClientCallback->setOverride($requestMethod, $url, (string) $string?->getRaw(), $statusCode);
    }

    /**
     * @Given /^there is a stubbed http interaction:$/
     */
    public function thereIsAStubbedHttpInteraction(PyStringNode $string): void
    {
        $interaction = HttpInteraction::createFromString($string->getRaw());

        $this->mockClientCallback->setHttpInteraction($interaction);
    }

    /**
     * @deprecated will be removed
     *
     * @Given /^the following json request is sent to the "([^"]*)" endpoint:$/
     */
    public function theFollowingJsonRequestIsSentToTheEndpoint(string $url, PyStringNode $string): void
    {
        $expectedJson = json_decode($string->getRaw(), true, 512, JSON_THROW_ON_ERROR);

        foreach ($this->mockClientCallback->getSentJsonRequests($url) as $payload) {
            if ($expectedJson == json_decode($payload, true, 512, JSON_THROW_ON_ERROR)) {
                return;
            }
        }

        throw new \RuntimeException('The request was not sent to the endpoint with the following payload: ' . $string->getRaw());
    }

    /**
     * @AfterStep
     */
    public function afterStep(AfterStepScope $scope): void
    {
        $givenStep = $scope->getStep();

        foreach ($scope->getFeature()->getScenarios() as $scenario) {
            $scenarioSteps = $scenario->getSteps();

            foreach ($scenarioSteps as $key => $step) {
                if ($givenStep === $step && array_key_last($scenarioSteps) === $key) {
                    $this->checkUnusedInteractions();
                }
            }
        }
    }


    public function checkUnusedInteractions(): void
    {
        $definedInteractions = $this->mockClientCallback->getInteractions();
        $sentInteractions = $this->mockClientCallback->getUsedInteractions();
        $definedContentableInteractions = $this->mockClientCallback->getContentableInteractions();
        $sentContentableInteractions = $this->mockClientCallback->getUsedContentableInteractions();

        if ($definedContentableInteractions != $sentContentableInteractions) {
            foreach ($definedContentableInteractions as $method => $urlsData) {
                foreach ($urlsData as $url => $urlData) {
                    foreach ($urlData as $contentType => $interactions) {
                        foreach ($interactions as $content => $interaction) {
                            if (!isset($sentContentableInteractions[$method][$url][$contentType][$content])) {
                                throw new \RuntimeException('Unused interaction for ' . $method . ' ' . $url . ' with content type ' . $contentType . ' with body ' . $content);
                            }
                        }
                    }
                }
            }
        }


        if ($definedInteractions != $sentInteractions) {
            foreach ($definedInteractions as $method => $urls) {
                foreach ($urls as $url => $interaction) {
                    if (!isset($sentInteractions[$method][$url])) {
                        throw new \RuntimeException('Unused interaction for ' . $method . ' ' . $url);
                    }
                }
            }
        }
    }
}
