<?php

declare(strict_types=1);

namespace Avodel\SymfonyBehatApi\Jwt;

use Avodel\SymfonyBehatApi\RestApi\HttpAuthorizationTokenProvider;
use Behat\Behat\Context\Context;
use JsonException;
use Lexik\Bundle\JWTAuthenticationBundle\Response\JWTAuthenticationSuccessResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\KernelInterface;

class JwtContext implements Context
{
    public function __construct(
        private readonly KernelInterface $kernel,
        private readonly HttpAuthorizationTokenProvider $httpAuthorizationTokenProvider,
    ) {
    }

    /**
     * @BeforeScenario
     */
    public function resetJwtToken(): void
    {
        $this->httpAuthorizationTokenProvider->setToken(null);
    }

    /**
     * @Given /^I request my token with "(GET|POST) ([^"]*)" using "([^"]*)" as username and "([^"]*)" as password$/
     *
     * @throws JsonException
     */
    public function iRequestMyTokenWithUsingAsUsernameAndAsPassword(
        string $method,
        string $path,
        string $username,
        string $password
    ): void {
        $payload = json_encode(['username' => $username, 'password' => $password], JSON_THROW_ON_ERROR);
        $response = $this->kernel->handle(
            Request::create($path, $method, [], [], [], ['CONTENT_TYPE' => 'application/json'], $payload)
        );

        if ($response instanceof JWTAuthenticationSuccessResponse) {
            $token = json_decode($response->getContent(), true, 512, JSON_THROW_ON_ERROR)['token'];
            $this->httpAuthorizationTokenProvider->setToken($token);
        }
    }

    /**
     * @Given /^I have invalid JWT$/
     */
    public function iHaveInvalidJWT(): void
    {
        $this->httpAuthorizationTokenProvider->setToken('invalid-jwt');
    }
}
