<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi\Async\Messenger;

use Avodel\TelegramBotApi\Contract\SendTelegramMessageExceptionInterface;
use Avodel\TelegramBotApi\Contract\TelegramApiInterface;
use Psr\Log\LoggerInterface;

final class EditMessageHandler
{
    public function __construct(
        private readonly TelegramApiInterface $telegramApi,
        private readonly LoggerInterface $logger,
    ) {
    }

    /**
     * @throws SendTelegramMessageExceptionInterface
     */
    public function __invoke(EditMessage $message): void
    {
        try {
            $this->telegramApi->editMessage($message->getChatId(), $message->getMessageId(), $message->getMessage());
        } catch (SendTelegramMessageExceptionInterface $e) {
            $this->logger->error('Error sending edit message.', [
                'exception' => $e,
                'chatId' => $message->getChatId(),
            ]);

            throw $e;
        }
    }
}
