<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi\Async\Messenger;

use Avodel\TelegramBotApi\Contract\SendInvoiceExceptionInterface;
use Avodel\TelegramBotApi\Contract\TelegramApiInterface;
use Psr\Log\LoggerInterface;

final class SendInvoiceHandler
{
    public function __construct(
        private readonly TelegramApiInterface $telegramApi,
        private readonly LoggerInterface $logger,
    ) {
    }

    /**
     * @throws SendInvoiceExceptionInterface
     */
    public function __invoke(SendInvoiceMessage $message): void
    {
        try {
            $this->telegramApi->sendInvoice($message->getChatId(), $message->getInvoice());
        } catch (SendInvoiceExceptionInterface $e) {
            $this->logger->error('Async invoice sending was failed.', [
                'exception' => $e,
                'chatId' => $message->getChatId(),
            ]);

            throw $e;
        }
    }
}
