<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi\Async\Messenger;

use Avodel\TelegramBotApi\Contract\MessageInterface;

final class SendMessage
{
    public function __construct(
        private readonly int $chatId,
        private readonly MessageInterface $message
    ) {
    }

    public function getChatId(): int
    {
        return $this->chatId;
    }

    public function getMessage(): MessageInterface
    {
        return $this->message;
    }
}
