<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi\Async\Messenger;

use Avodel\TelegramBotApi\Contract\SendTelegramMessageExceptionInterface;
use Avodel\TelegramBotApi\Contract\TelegramApiInterface;
use Psr\Log\LoggerInterface;

final class SendMessageHandler
{
    public function __construct(
        private readonly TelegramApiInterface $telegramApi,
        private readonly LoggerInterface $logger,
    ) {
    }

    /**
     * @throws SendTelegramMessageExceptionInterface
     */
    public function __invoke(SendMessage $message): void
    {
        try {
            $this->telegramApi->sendMessage($message->getChatId(), $message->getMessage());
        } catch (SendTelegramMessageExceptionInterface $e) {
            $this->logger->error('Async sending message was failed.', [
                'exception' => $e,
                'chatId' => $message->getChatId(),
            ]);

            throw $e;
        }
    }
}
