<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi;

use Avodel\TelegramBotApi\Contract\CallbackQueryButtonInterface;

final class CallbackQueryButton implements CallbackQueryButtonInterface
{
    public function __construct(
        private readonly string $text,
        private readonly string $callbackData,
        private readonly array $translationParameters = [],
    ) {
    }

    public function getText(): string
    {
        return $this->text;
    }

    public function getCallbackData(): string
    {
        return $this->callbackData;
    }

    public function withText(string $text): self
    {
        return new self($text, $this->callbackData, $this->translationParameters);
    }

    /**
     * @return array<string, string|int>
     */
    public function getTranslationParameters(): array
    {
        return $this->translationParameters;
    }
}
