<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi\Command;

use Avodel\TelegramBotApi\Contract\TelegramApiInterface;
use Avodel\TelegramBotApi\UpdateHandler;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(name: 'telegram:updates:get', description: 'Gets telegram updates for test purposes.',)]
final class GetTelegramUpdatesCommand extends Command
{
    private const EXECUTION_TIME_SEC = 60 * 15;

    public function __construct(
        private readonly TelegramApiInterface $telegramApi,
        private readonly UpdateHandler $updateHandler,
        private readonly EntityManagerInterface $entityManager,
    ) {
        parent::__construct();
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $startedAt = time();
        $offset = 0;

        while ($startedAt + self::EXECUTION_TIME_SEC > time()) {
            $this->entityManager->clear();
            $updates = $this->telegramApi->getUpdates($offset);

            foreach ($updates as $update) {
                $this->updateHandler->handleUpdate($update);
                $offset = $update['update_id'] + 1;
            }

            $output->writeln('Processed telegram updates.');
            sleep(1);
        }

        $output->writeln('Processing of Telegram updates is run out of time.');

        return Command::SUCCESS;
    }
}
