<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi;

use Avodel\TelegramBotApi\Contract\CommandInterface;
use Avodel\TelegramBotApi\Exception\CommandNotFoundException;
use Symfony\Component\DependencyInjection\Attribute\TaggedIterator;

final class CommandRegistry
{
    /**
     * @var array<string, CommandInterface>
     */
    private array $commands = [];

    /**
     * @param iterable|CommandInterface[] $commands
     */
    public function __construct(
        iterable $commands
    ) {
        foreach ($commands as $command) {
            $this->register($command);
        }
    }

    public function register(CommandInterface $command): void
    {
        $this->commands[$command->getName()] = $command;
    }

    /**
     * @throws CommandNotFoundException
     */
    public function getCommand(string $commandName): CommandInterface
    {
        if (!isset($this->commands[$commandName])) {
            throw CommandNotFoundException::create($commandName);
        }

        return $this->commands[$commandName];
    }
}
