<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi\Contract;

interface InvoiceInterface
{
    public function setPayload(string $payload): void;

    public function getPayload(): string;

    public function setUserId(int $userId): void;

    public function getUserId(): int;

    public function setProduct(string $product): void;

    public function getProduct(): string;

    public function setIssuedAt(\DateTimeImmutable $issuedAt): void;

    public function getIssuedAt(): \DateTimeImmutable;

    public function isPaid(): bool;

    public function setPaidAt(\DateTimeImmutable $paidAt): void;

    public function setPaid(bool $paid): void;

    public function getPaidAt(): ?\DateTimeImmutable;

    public function setPricingAmount(int $pricingAmount): void;

    public function getPricingAmount(): int;

    public function setPricingCurrency(string $pricingCurrency): void;

    public function getPricingCurrency(): string;
}
