<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi\Contract;

interface IssueInvoiceInterface
{
    public function getTitle(): string;

    public function getDescription(): string;

    public function getPayload(): string;

    public function getCurrency(): string;

    public function getProduct(): string;

    public function getPrice(): LabeledPriceInterface;

    /**
     * @return array<string, string>
     */
    public function getTranslationParameters(): array;
}
