<?php

namespace Avodel\TelegramBotApi\Contract;

use Avodel\TelegramBotApi\Message;

/**
 * @internal use Message::builder()
 */
class MessageBuilder
{
    private string $text = '';
    private array $inlineKeyboardLines = [];
    private ?string $textCallBack = null;
    private ?ParseMode $parseMode = null;
    private array $translationParameters = [];

    public static function create(): self
    {
        return new self();
    }

    public function text(string $text, array $translationParameters = []): self
    {
        $this->text = $text;
        $this->translationParameters = $translationParameters;

        return $this;
    }

    public function inlineKeyboardLines(array $inlineKeyboardLines): self
    {
        $this->inlineKeyboardLines = $inlineKeyboardLines;

        return $this;
    }

    public function inlineKeyboardLine(array $inlineKeyboardLine): self
    {
        $this->inlineKeyboardLines[] = $inlineKeyboardLine;

        return $this;
    }

    public function textCallBack(string $textCallBack): self
    {
        $this->textCallBack = $textCallBack;

        return $this;
    }

    public function parseMode(ParseMode $parseMode): self
    {
        $this->parseMode = $parseMode;

        return $this;
    }

    public function markdown(): self
    {
        $this->parseMode = ParseMode::MARKDOWN_V2;

        return $this;
    }

    public function build(): MessageInterface
    {
        return new Message(
            $this->text,
            $this->inlineKeyboardLines,
            $this->translationParameters,
            $this->textCallBack,
            $this->parseMode,
        );
    }
}
