<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi\Contract;

interface ThreadRepositoryInterface
{
    public function save(ThreadInterface $thread): void;

    /** @throws ThreadNotFoundExceptionInterface */
    public function getByMessageId(int $messageId): ThreadInterface;

    public function findOneById(string $id): ?ThreadInterface;
}
