<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi\Contract;

interface UserInterface extends ReadonlyUserInterface
{
    public function setId(int $id): void;

    public function setLanguageCode(string $languageCode): void;

    public function getFirstName(): string;

    public function setFirstName(string $firstName): void;

    public function getLastName(): string;

    public function setLastName(string $lastName): void;

    public function getUsername(): string;

    public function setUsername(string $username): void;

    public function getTextCallback(): ?string;

    public function getLastInteractedThreadId(): ?string;

    public function setLastInteractedThreadId(?string $lastInteractedThreadId): void;

    public function setTextCallback(?string $textCallback): void;

    public function setCreatedAt(\DateTimeImmutable $createdAt): void;

    public function getCreatedAt(): \DateTimeImmutable;
}
