<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi\DependencyInjection;

use Avodel\TelegramBotApi\ExceptionHandler;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;
use Symfony\Contracts\Translation\TranslatorInterface;

class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('avodel_telegram_bot_api');
        $rootNode = $treeBuilder->getRootNode();

        // @phpstan-ignore-next-line
        $rootNode
            ->children()
                ->scalarNode('token')->isRequired()->end()
                ->scalarNode('user_repository')->isRequired()->end()
                ->scalarNode('thread_repository')->isRequired()->end()
                ->scalarNode('user_class')->isRequired()->end()
                ->scalarNode('thread_class')->isRequired()->end()
                ->scalarNode('exception_handler')->defaultValue(ExceptionHandler::class)->end()
                ->scalarNode('translator')->defaultValue(TranslatorInterface::class)->end()
                ->scalarNode('base_url')->defaultValue('https://api.telegram.org')->end()
                ->booleanNode('async')->defaultFalse()->end()
                ->booleanNode('behat')->defaultFalse()->end()
                ->arrayNode('payments')
                    ->children()
                        ->scalarNode('provider_token')->isRequired()->end()
                        ->scalarNode('invoice_repository')->isRequired()->end()
                        ->scalarNode('enable_basic_pre_checkout_validation')->defaultTrue()->end()
                        ->arrayNode('products')->isRequired()
                            ->useAttributeAsKey('name')->requiresAtLeastOneElement()
                                ->arrayPrototype()
                                ->children()
                                    ->scalarNode('pre_checkout_validator')->defaultNull()->end()
                                    ->scalarNode('post_payment_processor')->defaultNull()->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end();

        return $treeBuilder;
    }
}
