<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi;

use Avodel\TelegramBotApi\Contract\IssueInvoiceInterface;
use Avodel\TelegramBotApi\Contract\LabeledPriceInterface;

final class IssueInvoice implements IssueInvoiceInterface
{
    public function __construct(
        private readonly string $title,
        private readonly string $description,
        private readonly string $payload,
        private readonly string $currency,
        private readonly LabeledPriceInterface $price,
        private readonly string $product,
        private readonly array $translationParameters = [],
    ) {
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    public function getDescription(): string
    {
        return $this->description;
    }

    public function getPayload(): string
    {
        return $this->payload;
    }

    public function getCurrency(): string
    {
        return $this->currency;
    }

    public function getProduct(): string
    {
        return $this->product;
    }

    public function getPrice(): LabeledPriceInterface
    {
        return $this->price;
    }

    /**
     * @inheritdoc
     */
    public function getTranslationParameters(): array
    {
        return $this->translationParameters;
    }
}
