<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi;

use Avodel\TelegramBotApi\Contract\LabeledPriceInterface;

final class LabeledPrice implements LabeledPriceInterface
{
    public function __construct(
        private readonly string $label,
        private readonly int $amount,
    ) {
    }

    public function getLabel(): string
    {
        return $this->label;
    }

    public function getAmount(): int
    {
        return $this->amount;
    }
}
