<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi;

use Avodel\TelegramBotApi\Contract\PreCheckoutValidatorInterface;

final class PreCheckoutValidatorsRegistry
{
    /**
     * @param iterable|PreCheckoutValidatorInterface[] $validators
     */
    public function __construct(
        private readonly iterable $validators = []
    ){
    }

    public function getValidator(string $product): ?PreCheckoutValidatorInterface
    {
        return $this->validators[$product] ?? null;
    }
}
