<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi;

use Avodel\TelegramBotApi\Contract\ReceivedTextMessageInterface;

final class ReceivedTextMessage implements ReceivedTextMessageInterface
{
    public function __construct(
        private readonly int $messageId,
        private readonly string $text
    ) {
    }

    public function getMessageId(): int
    {
        return $this->messageId;
    }

    public function getText(): string
    {
        return $this->text;
    }
}
