<?php

namespace Avodel\TelegramBotApi;

use Avodel\TelegramBotApi\Contract\ThreadInterface;
use Ramsey\Uuid\Uuid;

class ThreadFactory
{
    public function __construct(
        private readonly string $threadClass,
    ) {
    }

    public function createEmptyWithChatId(int $chatId): ThreadInterface
    {
        $thread = new $this->threadClass;
        $thread->setId(Uuid::uuid4()->toString());
        $thread->setChatId($chatId);

        return $thread;
    }
}
