<?php

namespace Avodel\TelegramBotApi;

use Avodel\TelegramBotApi\Contract\InvoiceRepositoryInterface;
use Avodel\TelegramBotApi\Contract\TelegramApiInterface;
use Avodel\TelegramBotApi\Contract\ThreadInteractorInterface;
use Avodel\TelegramBotApi\Contract\ThreadInterface;
use Avodel\TelegramBotApi\Contract\UserInterface;
use Symfony\Contracts\Translation\TranslatorInterface;

class ThreadInterfactorFactory
{
    public function __construct(
        private readonly TelegramApiInterface $telegramApi,
        private readonly TranslatorInterface $translator,
        private readonly ?InvoiceRepositoryInterface $invoiceRepository = null,
        private readonly ?InvoiceFactory $invoiceFactory = null,
    )
    {
    }

    public function create(UserInterface $user, ThreadInterface $thread): ThreadInteractorInterface
    {
        return new ThreadInteractor(
            $this->telegramApi,
            $this->translator,
            $thread,
            $user,
            $this->invoiceRepository,
            $this->invoiceFactory,
        );
    }
}
