<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi\UpdateHandler;

use Avodel\TelegramBotApi\Contract\UpdateHandlerInterface;
use Avodel\TelegramBotApi\Exception\NoSupportedUpdateHandlerException;
use Symfony\Component\DependencyInjection\Attribute\TaggedIterator;

final class UpdateHandlerRegistry
{
    /**
     * @param iterable|UpdateHandlerInterface[] $updateHandlers
     */
    public function __construct(
        private readonly iterable $updateHandlers
    ){
    }

    /**
     * @throws NoSupportedUpdateHandlerException
     */
    public function getSupportedHandler(array $update): UpdateHandlerInterface
    {
        foreach ($this->updateHandlers as $handler) {
            if ($handler->supports($update)) {
                return $handler;
            }
        }

        throw NoSupportedUpdateHandlerException::create();
    }
}
