<?php

namespace Tests\Avodel\TelegramBotApi\DependencyInjection;

use Avodel\TelegramBotApi\DependencyInjection\TelegramBotApiExtension;
use PHPUnit\Framework\TestCase;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Yaml\Parser;

final class TelegramBotApiExtensionTest extends TestCase
{
    public function testLoad(): void
    {
        $loader = new TelegramBotApiExtension();
        $config = $this->getFullConfig();
        $loader->load([$config], new ContainerBuilder());
        self::assertTrue(true);
    }

    /**
     * @return mixed
     */
    protected function getFullConfig()
    {
        $yaml = <<<EOF
token: 'telegram123455'
user_repository: UserRepository
thread_repository: ThreadRepository
user_class: User
thread_class: Thread
translator: translation_service.translator
base_url: https://api.telegram.org
behat: true
payments:
    provider_token: '1234567'
    invoice_repository: InvoiceRepository
    products:
        default:
            pre_checkout_validator: PreCheckoutValidatorServiceRef
            post_payment_processor: PostPaymentProcessorServiceRef
        default2:
            post_payment_processor: PostPaymentProcessorServiceRef
        default3:
        default4:
EOF;
        $parser = new Parser();

        return $parser->parse($yaml);
    }

}
