<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi\Async\Messenger;

use Avodel\TelegramBotApi\Contract\MessageInterface;

final class EditMessage
{
    public function __construct(
        private readonly int $chatId,
        private readonly int $messageId,
        private readonly MessageInterface $message
    ) {
    }

    public function getChatId(): int
    {
        return $this->chatId;
    }

    public function getMessageId(): int
    {
        return $this->messageId;
    }

    public function getMessage(): MessageInterface
    {
        return $this->message;
    }
}
