<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi\Async\Messenger;

use Avodel\TelegramBotApi\Contract\IssueInvoiceInterface;

final class SendInvoiceMessage
{
    public function __construct(
        private readonly int $chatId,
        private readonly IssueInvoiceInterface $invoice,
    ) {
    }

    public function getChatId(): int
    {
        return $this->chatId;
    }

    public function getInvoice(): IssueInvoiceInterface
    {
        return $this->invoice;
    }
}
