<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi\Behat;

use Avodel\TelegramBotApi\Contract\IssueInvoiceInterface;
use Avodel\TelegramBotApi\Contract\MessageInterface;
use Avodel\TelegramBotApi\Contract\PhotoInterface;
use Avodel\TelegramBotApi\Contract\SentMessageInterface;
use Avodel\TelegramBotApi\Contract\TelegramApiInterface;
use Avodel\TelegramBotApi\SentMessage;
use BadMethodCallException;

final class TelegramApiStub implements TelegramApiInterface
{
    /**
     * @var array<int, array<MessageInterface>>
     */
    private array $sentMessages = [];

    /**
     * @var array<int, array<IssueInvoiceInterface>>
     */
    private array $sentInvoices = [];

    /**
     * @var array<string, bool>
     */
    private array $sendAnswerPreCheckoutQueries = [];

    /**
     * @var array<int, array<string, array<string, string>>>
     */
    private array $chatMemberData = [];

    /**
     * @var array<int, int[]>
     */
    private array $deletedMessages = [];

    private int $receivedMessageId = 0;

    public function sendMessage(int $chatId, MessageInterface $message): SentMessageInterface
    {
        $this->sentMessages[$chatId][] = $message;

        return new SentMessage($this->receivedMessageId);
    }

    /**
     * @return array<int, array<MessageInterface>>
     */
    public function getSentMessages(): array
    {
        return $this->sentMessages;
    }

    /**
     * @return array<int, array<IssueInvoiceInterface>>
     */
    public function getSentInvoices(): array
    {
        return $this->sentInvoices;
    }

    /**
     * @return array<string, bool>
     */
    public function getSentAnswerPreCheckoutQueries(): array
    {
        return $this->sendAnswerPreCheckoutQueries;
    }

    public function editMessage(int $chatId, int $messageId, MessageInterface $message): void
    {
        $this->sentMessages[$chatId][] = $message;
    }

    public function sendInvoice(int $chatId, IssueInvoiceInterface $invoice): void
    {
        $this->sentInvoices[$chatId][] = $invoice;
    }

    public function answerPreCheckoutQuery(string $preCheckoutQueryId, bool $success): void
    {
        $this->sendAnswerPreCheckoutQueries[$preCheckoutQueryId] = $success;
    }

    public function getUpdates(int $offset = 0): array
    {
        return [];
    }

    public function sendPhoto(int $chatId, PhotoInterface $photo): void
    {
        throw new BadMethodCallException('The sendPhoto method is not supported.');
    }

    public function getChatMember(int $chatId, int $userId): array
    {
        return $this->chatMemberData[$userId] ?? [];
    }

    public function setChatMemberData(int $chatId, string $status): void
    {
        $this->chatMemberData[$chatId]['result']['status'] = $status;
    }

    public function deleteMessage(int $chatId, int $messageId): void
    {
        $this->deletedMessages[$chatId][] = $messageId;
    }

    /**
     * @return array<int, int[]>
     */
    public function getDeletedMessages(): array
    {
        return $this->deletedMessages;
    }

    public function setReceivedMessageId(int $messageId): void
    {
        $this->receivedMessageId = $messageId;
    }
}
