<?php

namespace Avodel\TelegramBotApi;

use Avodel\TelegramBotApi\Contract\CallbackQueryButtonInterface;
use Avodel\TelegramBotApi\Exception\CallbackQueryConvertingException;

class CallbackQueryConvertor
{
    public const TYPE_WILDCARD = 'wildcard';
    public const TYPE_BUTTON = 'button';

    public function convertButtonToCallbackData(CallbackQueryButtonInterface $callbackQueryButton): string
    {
        return match ($callbackQueryButton::class) {
            CallbackQueryButton::class => self::TYPE_BUTTON . ":{$callbackQueryButton->getCallbackData()}",
            WildcardCallbackQueryButton::class => self::TYPE_WILDCARD . ":{$callbackQueryButton->getCallbackData()}:{$callbackQueryButton->getValue()}",
            default => throw new \InvalidArgumentException('Unknown callback query button type ' . $callbackQueryButton::class),
        };
    }

    /** @throws CallbackQueryConvertingException */
    public function convertCallbackDataToReceivedMessage(int $messageId, string $rawCallbackData): ReceivedCallbackQueryMessage
    {
        $pattern = '/^(' . self::TYPE_WILDCARD . '|' . self::TYPE_BUTTON . '):[^:]+(:.*)?$/';

        $exception = CallbackQueryConvertingException::invalidFormat($rawCallbackData);

        if (preg_match($pattern, $rawCallbackData)) {
            $parts = explode(':', $rawCallbackData);
            [$type, $callbackData] = $parts;

            if ($type === self::TYPE_WILDCARD) {
                $value = implode(':', array_slice($parts, 2));
                if (!$value) {
                    throw $exception;
                }
            }

            return new ReceivedCallbackQueryMessage($messageId, $callbackData, $value ?? null);
        }

        throw $exception;
    }
}