<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi;

use Avodel\TelegramBotApi\Contract\CallbackQueryHandlerInterface;
use Avodel\TelegramBotApi\Exception\CallbackHandlerNotFoundException;
use Symfony\Component\DependencyInjection\Attribute\TaggedIterator;
use Webmozart\Assert\Assert;

final class CallbackQueryHandlerRegistry
{
    /**
     * @var array<string, CallbackQueryHandlerInterface>
     */
    private array $handlers = [];

    /**
     * @param iterable|CallbackQueryHandlerInterface[] $handlers
     */
    public function __construct(
        iterable $handlers
    ) {
        foreach ($handlers as $handler) {
            $this->register($handler);
        }
    }

    public function register(CallbackQueryHandlerInterface $handler): void
    {
        foreach ($handler->getSubscribedCallbacks() as $subscribedCallbackDatum) {
            Assert::keyNotExists($this->handlers, $subscribedCallbackDatum);
            $this->handlers[$subscribedCallbackDatum] = $handler;
        }
    }

    /**
     * @throws CallbackHandlerNotFoundException
     */
    public function getHandler(string $callbackData): CallbackQueryHandlerInterface
    {
        if (!isset($this->handlers[$callbackData])) {
            throw CallbackHandlerNotFoundException::fromCallbackData($callbackData);
        }

        return $this->handlers[$callbackData];
    }
}
