<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi\Contract;

interface TelegramApiInterface
{
    /**
     * @throws SendTelegramMessageExceptionInterface
     */
    public function sendMessage(int $chatId, MessageInterface $message): SentMessageInterface;

    /**
     * @throws SendTelegramMessageExceptionInterface
     */
    public function editMessage(int $chatId, int $messageId, MessageInterface $message): void;

    /**
     * @throws SendInvoiceExceptionInterface
     */
    public function sendInvoice(int $chatId, IssueInvoiceInterface $invoice): void;

    public function answerPreCheckoutQuery(string $preCheckoutQueryId, bool $success): void;

    public function getUpdates(int $offset = 0): array;

    public function sendPhoto(int $chatId, PhotoInterface $photo): void;

    /**
     * @throws GetChatMemberExceptionInterface
     */
    public function getChatMember(int $chatId, int $userId): array;

    /**
     * @throws DeleteMessageExceptionInterface
     */
    public function deleteMessage(int $chatId, int $messageId): void;
}
