<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi\Contract;

interface ThreadInteractorInterface
{
    public function getUser(): ReadonlyUserInterface;

    public function writeState(ThreadStateInterface $state): void;

    /**
     * @template T
     * @phpstan-template T of ThreadStateInterface
     *
     * @param class-string<T> $className
     */
    public function unsetState(string $className): void;

    /**
     * @template T
     * @phpstan-template T of ThreadStateInterface
     *
     * @param class-string<T> $className
     *
     * @return T
     * @phpstan-return T
     */
    public function readState(string $className): ThreadStateInterface;

    public function reply(MessageInterface $message): SentMessageInterface;

    public function issueInvoice(IssueInvoiceInterface $issueInvoice): InvoiceInterface;
}
