<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi\Contract;

interface UpdateHandlerInterface
{
    /**
     * @param array<string, string|array|int|bool|null> $update
     * @return void
     */
    public function handle(array $update): void;

    /**
     * @param array<string, string|array|int|bool|null> $update
     * @return bool
     */
    public function supports(array $update): bool;
}
