<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi\Exception;

use Exception;

class CallbackHandlerNotFoundException extends Exception
{
    public static function fromCallbackData(string $callbackData): self
    {
        return new self(sprintf('The callback handler for `%s` button was not found.', $callbackData));
    }
}
