<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi\Exception;

use Avodel\TelegramBotApi\CallbackQueryConvertor;
use RuntimeException;

final class CallbackQueryConvertingException extends RuntimeException
{

    public static function invalidFormat(string $rawCallbackData): CallbackQueryConvertingException
    {
        return new self('Invalid callback data format. Format should be "' . CallbackQueryConvertor::TYPE_BUTTON . ':{callback_id}" or "' . CallbackQueryConvertor::TYPE_WILDCARD . ':{callback_id}:{value}". Given: ' . $rawCallbackData);
    }

}
