<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi;

use Avodel\TelegramBotApi\Contract\ExceptionHandlerInterface;
use Avodel\TelegramBotApi\Contract\SendTelegramMessageExceptionInterface;
use Avodel\TelegramBotApi\Contract\TelegramApiInterface;
use Psr\Log\LoggerInterface;
use Throwable;

final class ExceptionHandler implements ExceptionHandlerInterface
{
    public function __construct(
        private readonly LoggerInterface $logger,
        private readonly TelegramApiInterface $telegramApi,
    )
    {
    }

    /**
     * @throws SendTelegramMessageExceptionInterface
     */
    public function handle(array $update, int $userId, Throwable $throwable): void
    {
        $this->telegramApi->sendMessage($userId, new Message('Something went wrong. Please, try again'));
        $this->logger->error('Telegram update handling failed with error.', [
            'exception' => $throwable,
            'update' => $update,
        ]);
    }
}
