<?php

namespace Avodel\TelegramBotApi;

use Avodel\TelegramBotApi\Contract\InvoiceInterface;
use Avodel\TelegramBotApi\Contract\InvoiceRepositoryInterface;
use Psr\Clock\ClockInterface;

class InvoiceFactory
{
    public function __construct(
        private readonly InvoiceRepositoryInterface $invoiceRepository,
        private readonly ClockInterface $clock
    ) {
    }

    public function create(string $payload, string $product, int $userId, int $pricingAmount, string $pricingCurrency): InvoiceInterface
    {
        $invoice = $this->invoiceRepository->getBlank();
        $invoice->setPayload($payload);
        $invoice->setIssuedAt($this->clock->now());
        $invoice->setProduct($product);
        $invoice->setPricingAmount($pricingAmount);
        $invoice->setPricingCurrency($pricingCurrency);
        $invoice->setUserId($userId);

        return $invoice;
    }
}
