<?php

namespace Avodel\TelegramBotApi;

use Avodel\TelegramBotApi\Contract\IssueInvoiceFactoryInterface;
use Avodel\TelegramBotApi\Contract\IssueInvoiceInterface;
use Avodel\TelegramBotApi\Contract\PayloadGeneratorInterface;

class IssueInvoiceFactory implements IssueInvoiceFactoryInterface
{
    public function __construct(
        private readonly string $product,
        private readonly PayloadGeneratorInterface $payloadGenerator
    ) {
    }

    /**
     * @inheritdoc
     */
    public function create(string $title, string $description, string $currency, string $priceLabel, int $priceAmount, array $translationParameters = []): IssueInvoiceInterface
    {
        return new IssueInvoice(
            $title,
            $description,
            $this->payloadGenerator->generate(),
            $currency,
            new LabeledPrice($priceLabel, $priceAmount),
            $this->product,
            $translationParameters,
        );
    }
}
