<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi;

use Avodel\TelegramBotApi\Contract\CallbackQueryButtonInterface;
use Avodel\TelegramBotApi\Contract\MessageBuilder;
use Avodel\TelegramBotApi\Contract\MessageInterface;
use Avodel\TelegramBotApi\Contract\ParseMode;

final class Message implements MessageInterface
{
    public function __construct(
        private readonly string $text,
        /**
         * @var array<array<CallbackQueryButtonInterface>>
         */
        private readonly array $inlineKeyboard = [],
        private readonly array $translationParameters = [],
        private readonly ?string $callback = null,
        private readonly ?ParseMode $parseMode = null,
    ) {
    }

    public function getText(): string
    {
        return $this->text;
    }

    public function getTranslationParameters(): array
    {
        return $this->translationParameters;
    }

    /**
     * @inheritdoc
     */
    public function getInlineKeyboardLines(): array
    {
        return $this->inlineKeyboard;
    }

    public function getCallback(): ?string
    {
        return $this->callback;
    }

    public function getParseMode(): ?ParseMode
    {
        return $this->parseMode;
    }

    public static function builder(): MessageBuilder
    {
        return new MessageBuilder();
    }
}
