<?php

namespace Avodel\TelegramBotApi;

use Avodel\TelegramBotApi\Contract\PhotoInterface;

final class Photo implements PhotoInterface
{
    public function __construct(
        private readonly string $photoPath,
        private readonly string $caption,
    )
    {
    }

    public function getPhotoPath(): string
    {
        return $this->photoPath;
    }

    public function getCaption(): string
    {
        return $this->caption;
    }

}