<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi;

use Avodel\TelegramBotApi\Contract\PostPaymentProcessorInterface;

final class PostPaymentProcessorsRegistry
{
    /**
     * @param array<string, PostPaymentProcessorInterface> $processors
     */
    public function __construct(
        private readonly iterable $processors = []
    ){
    }

    public function getProcessor(string $product): ?PostPaymentProcessorInterface
    {
        return $this->processors[$product] ?? null;
    }
}
