<?php

namespace Avodel\TelegramBotApi;

use Avodel\TelegramBotApi\Contract\PreCheckoutQueryInterface;

class PreCheckoutQuery implements PreCheckoutQueryInterface
{
    public function __construct(
        private readonly string $preCheckoutQueryId,
        private readonly int    $totalAmount,
        private readonly string $invoicePayload,
        private readonly string $currency,
    )
    {
    }

    public function getPreCheckoutQueryId(): string
    {
        return $this->preCheckoutQueryId;
    }

    public function getTotalAmount(): int
    {
        return $this->totalAmount;
    }

    public function getInvoicePayload(): string
    {
        return $this->invoicePayload;
    }

    public function getCurrency(): string
    {
        return $this->currency;
    }

    public static function createFromPreCheckoutQueryUpdate(array $preCheckoutUpdate): self
    {
        return new self($preCheckoutUpdate['id'], $preCheckoutUpdate['total_amount'], $preCheckoutUpdate['invoice_payload'], $preCheckoutUpdate['currency']);
    }
}