<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi;

use Avodel\TelegramBotApi\Contract\ReceivedCallbackQueryMessageInterface;

final class ReceivedCallbackQueryMessage implements ReceivedCallbackQueryMessageInterface
{
    public function __construct(
        private readonly int $messageId,
        private readonly string $callbackData,
        private readonly ?string $value
    ) {
    }

    public function getCallbackData(): string
    {
        return $this->callbackData;
    }

    public function getMessageId(): int
    {
        return $this->messageId;
    }

    public function getValue(): null|string
    {
        return $this->value;
    }
}
