<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi;

use Avodel\TelegramBotApi\Contract\CallbackQueryHandlerInterface;
use Avodel\TelegramBotApi\Contract\CommandInterface;
use Avodel\TelegramBotApi\Contract\TextMessageHandlerInterface;
use Avodel\TelegramBotApi\Contract\UpdateHandlerInterface;
use Avodel\TelegramBotApi\DependencyInjection\TelegramBotApiExtension;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\ExtensionInterface;
use Symfony\Component\HttpKernel\Bundle\Bundle;

class TelegramBotApiBundle extends Bundle
{
    public function getContainerExtension(): ?ExtensionInterface
    {
        return new TelegramBotApiExtension();
    }

    public function build(ContainerBuilder $container): void
    {
        parent::build($container);

        $container->registerForAutoconfiguration(UpdateHandlerInterface::class)
            ->addTag('telegram.update_handler')
        ;

        $container->registerForAutoconfiguration(CallbackQueryHandlerInterface::class)
            ->addTag('telegram.callback_query_handler')
        ;

        $container->registerForAutoconfiguration(CommandInterface::class)
            ->addTag('telegram.command')
        ;

        $container->registerForAutoconfiguration(TextMessageHandlerInterface::class)
            ->addTag('telegram.text_message_handler')
        ;
    }
}