<?php

namespace Avodel\TelegramBotApi;

use Avodel\TelegramBotApi\Contract\UserInterface;
use Psr\Clock\ClockInterface;

class UserFactory
{
    public function __construct(
        private readonly ClockInterface $clock,
        private readonly string $userClass,
    ) {
    }

    public function create(array $from): UserInterface
    {
        $user = new $this->userClass;
        $user->setId($from['id']);
        $user->setLanguageCode($from['language_code'] ?? 'en');
        $user->setFirstName($from['first_name'] ?? '');
        $user->setLastName($from['last_name'] ?? '');
        $user->setUsername($from['username'] ?? '');
        $user->setCreatedAt($this->clock->now());

        return $user;
    }
}
