<?php

declare(strict_types=1);

namespace Avodel\TelegramBotApi;

use Avodel\TelegramBotApi\Contract\CallbackQueryButtonInterface;

final class WildcardCallbackQueryButton implements CallbackQueryButtonInterface
{
    public function __construct(
        private readonly string $text,
        private readonly string $callbackData,
        private readonly int|string $value,
        private readonly array $translationParameters = [],
    ) {
    }

    public function getText(): string
    {
        return $this->text;
    }

    public function getCallbackData(): string
    {
        return $this->callbackData;
    }

    public function getValue(): int|string
    {
        return $this->value;
    }

    public function withText(string $text): self
    {
        return new self($text, $this->callbackData, $this->value, $this->translationParameters);
    }

    /**
     * @return array<string, string|int>
     */
    public function getTranslationParameters(): array
    {
        return $this->translationParameters;
    }
}
