<?php

declare(strict_types=1);

namespace Avodel\Uuid\Behat;

use Behat\Behat\Context\Context;

class UuidContext implements Context
{
    public function __construct(
        private readonly UuidGeneratorStub $uuidGenerator,
    ) {
    }

    /**
     * @Given /^next UUID is going to be "([^"]*)"$/
     */
    public function nextUUIDIsGoingToBe(string $uuid): void
    {
        $this->uuidGenerator->setNextUuid($uuid);
    }
}
