<?php

declare(strict_types=1);

namespace Avodel\Uuid\Behat;

use Avodel\Uuid\UuidGeneratorInterface;
use Ramsey\Uuid\Uuid;

class UuidGeneratorStub implements UuidGeneratorInterface
{
    private ?string $nextUuid = null;

    public function setNextUuid(string $uuid): void
    {
        $this->nextUuid = $uuid;
    }
    public function generate(): string
    {
        if ($this->nextUuid) {
            $uuidToReturn = $this->nextUuid;
            $this->nextUuid = null;

            return $uuidToReturn;
        }

        return Uuid::uuid4()->toString();
    }
}
