<?php

namespace Avodel\WebBot\Extension\Captcha;

use Avodel\WebBot\Context\Context;
use Avodel\WebBot\Worker\ActionInterface;
use Avodel\WebDriver\WebDriver;
use Facebook\WebDriver\Exception\NoSuchFrameException;
use Facebook\WebDriver\Exception\StaleElementReferenceException;
use Psr\Log\LoggerInterface;

final readonly class CaptchaVerifierAction implements ActionInterface
{
    public function __construct(
        private LoggerInterface $logger,
    )
    {
    }

    public function perform(WebDriver $webDriver, Context $context): void
    {
        $framesHandler = $webDriver->getFramesHandler();
        $frames = $framesHandler->getFrames();

        foreach ($frames as $frame) {
            try {
                $framesHandler->switchToIFrame($frame->getPath());

                if ($webDriver->getCaptchaVerifier()->isVerificationRequired()) {
                    $this->logger->info('Starting captcha verification process.');
                    $webDriver->getCaptchaVerifier()->verify();
                    $this->logger->info('Verification processed.');
                    return;
                }
            } catch (NoSuchFrameException|StaleElementReferenceException) {
                continue;
            } finally {
                $framesHandler->switchToMainWindow();
            }
        }
    }

    public function isApplicable(WebDriver $webDriver, Context $context): bool
    {
        $framesHandler = $webDriver->getFramesHandler();
        $frames = $framesHandler->getFrames();

        foreach ($frames as $frame) {
            try {
                $framesHandler->switchToIFrame($frame->getPath());

                if ($webDriver->getCaptchaVerifier()->isVerificationRequired()) {
                    return true;
                }
            } catch (NoSuchFrameException|StaleElementReferenceException) {
                continue;
            } finally {
                $framesHandler->switchToMainWindow();
            }
        }

        return false;
    }
}
