<?php

declare(strict_types=1);

namespace Avodel\WebBot\Extension\Sleep;

use Avodel\WebBot\Context\Context;
use Avodel\WebBot\Worker\ActionInterface;
use Avodel\WebDriver\WebDriver;
use DateTimeImmutable;
use Override;
use Psr\Clock\ClockInterface;

final class SleepBetweenActionsAction implements ActionInterface
{
    private ?DateTimeImmutable $nextSleepAt = null;

    public function __construct(
        private readonly ClockInterface $clock,
    )
    {
    }

    #[Override]
    public function perform(WebDriver $webDriver, Context $context): void
    {
        $options = $context->getOptions();

        sleep(random_int($options->getSleepBetweenActionsMinSec(), $options->getSleepBetweenActionsMaxSec()));
        $this->nextSleepAt = $this->clock->now()->modify('+1 second');
    }

    #[Override]
    public function isApplicable(WebDriver $webDriver, Context $context): bool
    {
        if ($context->getOptions()->getSleepBetweenActionsMaxSec() <= 0) {
            return false;
        }

        return !$this->nextSleepAt || $this->nextSleepAt < $this->clock->now();
    }
}
