<?php

namespace Avodel\WebBot\Context;

final readonly class Options
{
    public function __construct(
        private Schedule $schedule,
        private ?int $timeLimitSec = null,
        private int $sleepBetweenActionsMinSec = 0,
        private int $sleepBetweenActionsMaxSec = 0,
        private array $upstreamProxyServers = [],
        private ?int $rotateUpstreamProxyServerIntervalSec = null,
        private ?string $tag = null,
        private bool $requireActualUserAgent = false,
    )
    {
    }

    public static function builder(): OptionsBuilder
    {
        return new OptionsBuilder();
    }

    public function getTimeLimitSec(): ?int
    {
        return $this->timeLimitSec;
    }

    public function getSleepBetweenActionsMinSec(): int
    {
        return $this->sleepBetweenActionsMinSec;
    }

    public function getSleepBetweenActionsMaxSec(): int
    {
        return $this->sleepBetweenActionsMaxSec;
    }

    public function getUpstreamProxyServers(): array
    {
        return $this->upstreamProxyServers;
    }

    public function getRotateUpstreamProxyServerIntervalSec(): ?int
    {
        return $this->rotateUpstreamProxyServerIntervalSec;
    }

    public function getTag(): ?string
    {
        return $this->tag;
    }

    public function isRequireActualUserAgent(): bool
    {
        return $this->requireActualUserAgent;
    }

    public function getSchedule(): Schedule
    {
        return $this->schedule;
    }
}
